# Vespucci 16.0 Highlights

2021-09-21

This was originally intended as a minor version step over 15.2, however both the scope of the changes and the time it has taken warrants to release this with a new major version. 

### Changed public app directory for Android 11 compatibility

In November of this year we will have to start targeting Android 11 to ensure continued availability on googles play store, this forced change implies that we can no longer store any user accessible / selectable files in the traditional "Vespucci" directory, nor in the app specific directories in Android/data. There is no really satisfactory solution to where to store non-media content, however using "Download/Vespucci" has emerged as the best (or rather the least awlful) compromise.

In preparation for targeting Android 11, on 1st startup of 16.0 your data will be copied to the new location, once you are sure that everything works as expected you can remove the old directory and contents. Note: if you have a larger number of photographs in 'Vespucci/Pictures' the migration may take a significant amount of time.

If you have been using offline OSM data in mapsplit format, you may need to adjust the location of the MSF files in the API entries to the new location.

### Tile download moved to main process

Since 2010 when Marcus added background layer functionality to Vespucci the tile fetching and storing logic lived in a separate service that communicated with the main editing application via remote procedure calls. This served us well over more than the last decade, however always had an inherent issue due to an Android quirk, the buffer used for these calls has a fixed size of 1MB, shared by all transactions running in the same process. This now and then caused issues with very large tiles, but in general was manageable without direct impact on functionality. It did limit the size of images that could be retrieved from WMS servers and use of image formats without compression.

However with support for Mapbox vector tiles this architecture has become untenable. This is obvious considering that, for example, Mapillary serves vector tiles that are around 10MB size in areas with high density data. 

The code has been reworked to run directly in the main process in this release, while due to this it is no longer quite as robust as previously, there are some performance gains outside of the ability to handle larger tiles that might be noticeable.

### Mapillary V4 API

In February of this year Mapillary announced that they were replacing their V3 API with a vector tile based implementation. While the original announcement communicated that a test API V4 implementation would be available in March and the cut over would be in May, both API and documentation for it were then eventually made available mid-June. As a result the current implementation has a number of rough edges, workarounds and other issues that cropped up in the short time available.

In particular the zoom level 14 tiles containing image information can be in the order of magnitude of 10MB (a bitmap . Rendering a complete screen of so large tiles at zoom 14 can easily exceed the complete heap available to an Android app (on recent devices, not to mention older ones), to avoid issues caused by exhausting memory we currently limit Mapillary rendering to zoom level 16 and higher. The limit can be adjusted in the advanced preferences and likely should be set to a higher value on devices, such as tablets, with larger screens.

_Note for F-Droid users:_ just as the previous support for Mapillary, this functionality is not available for third party builds, in particular for builds by F-Droid, as they do not support private API keys. You can naturally obtain a key from Mapillary and build the app yourself.

### Mapbox vector tile and styling support

Vespucci now has limited support for Mapbox Vector tiles and styling with a subset of Mapbox GL, this is mainly useful for quality assurance layers and other overlays. As currently neither of the imagery layer configurations support MVT sources, for now such sources have to be added via the custom imagery dialog. Rudimentary styles can be created interactively or you can load a Mapbox-GL style file from devices storage. 

More information can be found here [Mapbox-GL Style Support](http://vespucci.io/tutorials/mapbox-style/).  

### Bookmarks

You can now store the current location as a named bookmark and retrieve them to return back to the stored location at a later date. Thanks to https://github.com/Akaash7 for implementing this!

### Support for way labels

Data styling now supports rendering labels along ways.

### GPX layer performance improvement

Rendering a large number of GPX tracks at low zooms is now considerably faster due to some geometry simplification implemented by https://github.com/kai-morich Thanks!


## Miscellaneous

- Preference for tile storage location
- Filter background layer by terrain in imagery selector. Thanks to https://github.com/zedlabs
- Add styling for icons on amenity, shop and tourist tags on closed ways
- Add layer info button in imagery selector. Thanks to https://github.com/zedlabs
- Name suggestion index V6 format support
- Updated opening hours editor with support for matching templates with wild cards
- Improved data styles that render much more icons on buildings

# Upgrading from previous versions

* As a safety measure, you should always upload any changes before updating.
* As mentioned above the default public directory used to store files has changed, please check that everything has been correctly migrated.
* The default tile size for requests from WMS servers has increased, old tiles stored in the on-device cache will have the wrong size and as a result will not be displayed properly, clear the tile cache to fix the issue.
* Potentially the mapillary layer will have the wrong style, discard the layer and then re-add it to address the problem.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
